#include "General.h"
#include "Sounds.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "gmgame.h"

HashTemplateClass<StringClass, StringClass> SoundsTable;

Sounds::Sounds()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

Sounds::~Sounds()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void Sounds::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	char number[8];
	char buffer[256];
	for(int i = 1; i < 256; i++)
	{
		sprintf(number, "%.2d", i);
		SSGMIni->Get_String("Sounds_Plugin", number, "", buffer, 256);
			
		if(*number != 0)
		{
			char Trigger[256];
			char Sound[256];
			if(sscanf(buffer, "%s %s", Trigger, Sound) == 2)
			{
				SoundsTable.Insert(Trigger, Sound);
				continue;
			}
		}
	break;
	}
}

void Sounds::OnFreeData()
{
}




bool Sounds::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Type != TEXT_MESSAGE_PUBLIC) return true;
	StringClass Msg = Message;

	if (SoundsTable.Exists(Msg))
	{
		char buffer[256];
		sprintf(buffer, "snda %s", SoundsTable.Get(Msg, ""));
		Console_Input(buffer);
		return true;			
	}

	if (Message[0] == L'!')
	{
		if (wcsistr(Message,L"!sounds8") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: woops, whoa, yeah2, ha, hey2, yes_sir2, yes_sir3, ow2, pin7, rape, ty, 1, 2, 3, 4, smart, yo, bird, time_to_die, elena, gogogo, orca_volley, whip, all_right, ceiling_turret");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds7") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: watch_out, help2, squirrel, run, yell, np, wow, stay_down, got_one, cool, bigheads, wasted, kane, phew, superman, hero, oo, o.o, comeon, cmon, gun, ambulance, flies");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds6") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: bear, rooster, battle, dogs, petrova, pet, job_hazard, out_of_the_way, who_is_there, call_a_doctor, man_down, dance, headache, munchies, dont_shoot, quiet, heads_up");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds5") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: situation_under_control, time_for_action, support, gotcha, gotya, coffee, ask, hunt, boo, pray, amateur, eye, lucky, finally, mobius, system_backup, dubi, shatter, hit, bravo");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds4") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: candy, boink, boink2, door, rain, destruction, yes, rav, father, tv, help, dont_shoot_me, hello, hi, hi2, haha, muhaha, hihi, move, medic, elephants, ow, aw, not_now");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds3") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: negattive, sorry, die, affirmative, bye, cya, aha, traffic, terrorist, shutup, stfu, destroy, no, whoops, ns, fun, unstable, guys, where, meee, target, attack, bla, junior");
			Console_Input(msg2);
			return false;
		}
		else if (wcsistr(Message,L"!sounds2") == Message)
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: burn, stupid, mechman, bell, inc, cow, creak, sak, monster, run2, what, clear, hurry, kill_him, jerks, gameover, gg, helidown, hmm, hey, heh, go, fight, cover_me");
			Console_Input(msg2);
			return false;
		}
		else if ((wcsistr(Message,L"!sounds1") == Message) || (wcsistr(Message,L"!sounds") == Message))
		{
			char msg2[256];
			sprintf(msg2, "msg [SSGM]: chicky, skill, hehe, hh, tt, tuff, yes_sir, yeah, fall, got_it, grunt, good, dead, oops, creature, lol, roar, target, incinerate, fire, smell, ^^, toast, pain, present");
			Console_Input(msg2);
			return false;
		}
	}
	return true;
}


Sounds Sounds;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &Sounds;
}
